package com.ejie.aa17a.control;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa17a.model.Aa17aContaminanteEstacion;
import com.ejie.aa17a.service.iface.Aa17aContaminanteEstacionService;

/**
 * Aa17aContaminanteEstacionController generated by UDA, 18-dic-2013 15:36:30.
 * 
 * @author UDA
 */

@RequestMapping(value = "/contaminantesestacion")
public class Aa17aContaminanteEstacionController {

	private static final Logger logger = LoggerFactory.getLogger(Aa17aContaminanteEstacionController.class);

	private Aa17aContaminanteEstacionService aa17aContaminanteEstacionService;

	/**
	 * Method 'getById'.
	 * 
	 * @param idEstacion
	 *            Long
	 * @return aa17aContaminanteEstacion Aa17aContaminanteEstacion
	 */
	@RequestMapping(value = "/{idEstacion}", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa17aContaminanteEstacion> getContaminantesEstacion(@PathVariable Long idEstacion) {
		Aa17aContaminanteEstacion aa17aContaminanteEstacion = new Aa17aContaminanteEstacion();
		aa17aContaminanteEstacion.setIdEstacion(idEstacion);
		Aa17aContaminanteEstacionController.logger.info("[GET - getContaminantesEstacion] : Obtener lista de contaminantes por estacion");
		return this.aa17aContaminanteEstacionService.getContaminantes(aa17aContaminanteEstacion);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idEstacion
	 *            Long
	 * @param idContaminante
	 *            Long
	 * @return aa17aContaminanteEstacion Aa17aContaminanteEstacion
	 */
	@RequestMapping(value = "/{idEstacion}/{idContaminante}", method = RequestMethod.GET)
	public @ResponseBody
	Aa17aContaminanteEstacion getContaminanteEstacion(@PathVariable Long idEstacion, @PathVariable Long idContaminante) {
		Aa17aContaminanteEstacion aa17aContaminanteEstacion = new Aa17aContaminanteEstacion();
		aa17aContaminanteEstacion.setIdEstacion(idEstacion);
		aa17aContaminanteEstacion.setIdContaminante(idContaminante);
		Aa17aContaminanteEstacionController.logger.info("[GET - getContaminanteEstacion] : Obtener lista de contaminantes por estacion");
		return this.aa17aContaminanteEstacionService.getContaminanteEstacion(aa17aContaminanteEstacion);
	}

	/**
	 * Method 'setAa17aContaminanteEstacionService'.
	 * 
	 * @param aa17aContaminanteEstacionService
	 *            Aa17aContaminanteEstacionService
	 * @return
	 */
	public void setAa17aContaminanteEstacionService(Aa17aContaminanteEstacionService aa17aContaminanteEstacionService) {
		this.aa17aContaminanteEstacionService = aa17aContaminanteEstacionService;
	}
}
